#!/usr/bin/env python

# A port to PyTQt of the application example from TQt v2.x.


import sys, string
from qt import *

TRUE  = 1
FALSE = 0
fileopen = [
'    16    13        5            1',
'. c #040404',
'# c #808304',
'a c None',
'b c #f3f704',
'c c #f3f7f3',
'aaaaaaaaa...aaaa',
'aaaaaaaa.aaa.a.a',
'aaaaaaaaaaaaa..a',
'a...aaaaaaaa...a',
'.bcb.......aaaaa',
'.cbcbcbcbc.aaaaa',
'.bcbcbcbcb.aaaaa',
'.cbcb...........',
'.bcb.#########.a',
'.cb.#########.aa',
'.b.#########.aaa',
'..#########.aaaa',
'...........aaaaa'
]

filesave = [
'    14    14        4            1',
'. c #040404',
'# c #808304',
'a c #bfc2bf',
'b c None',
'..............',
'.#.aaaaaaaa.a.',
'.#.aaaaaaaa...',
'.#.aaaaaaaa.#.',
'.#.aaaaaaaa.#.',
'.#.aaaaaaaa.#.',
'.#.aaaaaaaa.#.',
'.##........##.',
'.############.',
'.##.........#.',
'.##......aa.#.',
'.##......aa.#.',
'.##......aa.#.',
'b.............'
]

fileprint = [
'    16    14        6            1',
'. c #000000',
'# c #848284',
'a c #c6c3c6',
'b c #ffff00',
'c c #ffffff',
'd c None',
'ddddd.........dd',
'dddd.cccccccc.dd',
'dddd.c.....c.ddd',
'ddd.cccccccc.ddd',
'ddd.c.....c....d',
'dd.cccccccc.a.a.',
'd..........a.a..',
'.aaaaaaaaaa.a.a.',
'.............aa.',
'.aaaaaa###aa.a.d',
'.aaaaaabbbaa...d',
'.............a.d',
'd.aaaaaaaaa.a.dd',
'dd...........ddd'
]

class ABCentralWidget( TQWidget ):
    def __init__( self, *args ):
        apply( TQWidget.__init__, (self, ) + args )
        self.mainGrid = TQGridLayout( self, 2, 1, 5, 5 )

        self.setupTabWidget()
        self.setupListView()
        
        self.mainGrid.setRowStretch( 0, 0 )
        self.mainGrid.setRowStretch( 1, 1 )

    def save( self, filename ):
        if not self.listView.firstChild():
            return

        f = TQFile( filename )
        if not f.open( IO_WriteOnly ):
            return

        t = TQTextStream( f )

        #it = TQListViewItemIterator( self.listView )

        while not t.eof():
            item = TQListViewItem( self.listView )
            for i in range (0, 4):
                t << item.text( i ) << '\n'
        #for it in it.current():
            #for i in range (0, 4):
                #t << it.current().text[ i ] << "\n"

        f.close()


    def load( self, filename ):
        self.listView.clear()

        f = TQFile( filename )
        if not f.open( IO_ReadOnly ):
            return

        t = TQTextStream( f )

        while not t.eof():
            item = TQListViewItem( self.listView )
            for i in range (0, 4):
                item.setText( i, t.readLine() )
    
        f.close();


    def setupTabWidget( self ):
        self.tabWidget = TQTabWidget( self )

        self.input = TQWidget( self.tabWidget )
        self.grid1 = TQGridLayout( self.input, 2, 5, 5, 5 )

        self.liFirstName = TQLabel( 'First &Name', self.input )
        self.liFirstName.resize( self.liFirstName.sizeHint() )
        self.grid1.addWidget( self.liFirstName, 0, 0 )

        self.liLastName = TQLabel( '&Last Name', self.input )
        self.liLastName.resize( self.liLastName.sizeHint() )
        self.grid1.addWidget( self.liLastName, 0, 1 )

        self.liAddress = TQLabel( '&Address', self.input )
        self.liAddress.resize( self.liAddress.sizeHint() )
        self.grid1.addWidget( self.liAddress, 0, 2 )

        self.liEMail = TQLabel( '&E-Mail', self.input )
        self.liEMail.resize( self.liEMail.sizeHint() )
        self.grid1.addWidget( self.liEMail, 0, 3 )

        self.add = TQPushButton( '&Add', self.input )
        self.add.resize( self.add.sizeHint() )
        self.grid1.addWidget( self.add, 0, 4 )
        self.connect( self.add, SIGNAL( 'clicked()' ), self.addEntry )

        self.iFirstName = TQLineEdit( self.input )
        self.iFirstName.resize( self.iFirstName.sizeHint() )
        self.grid1.addWidget( self.iFirstName, 1, 0 )
        self.liFirstName.setBuddy( self.iFirstName )

        self.iLastName = TQLineEdit( self.input )
        self.iLastName.resize( self.iLastName.sizeHint() )
        self.grid1.addWidget( self.iLastName, 1, 1 )
        self.liLastName.setBuddy( self.iLastName )

        self.iAddress = TQLineEdit( self.input )
        self.iAddress.resize( self.iAddress.sizeHint() )
        self.grid1.addWidget( self.iAddress, 1, 2 )
        self.liAddress.setBuddy( self.iAddress )

        self.iEMail = TQLineEdit( self.input )
        self.iEMail.resize( self.iEMail.sizeHint() )
        self.grid1.addWidget( self.iEMail, 1, 3 )
        self.liEMail.setBuddy( self.iEMail )

        self.change = TQPushButton( '&Change', self.input )
        self.change.resize( self.change.sizeHint() )
        self.grid1.addWidget( self.change, 1, 4 )
        self.connect( self.change, SIGNAL( 'clicked()' ), self.changeEntry )

        self.tabWidget.addTab( self.input, '&Add/Change Entry' )

        # --------------------------------------

        self.search = TQWidget( self )
        self.grid2 = TQGridLayout( self.search, 2, 5, 5, 5 )

        self.cFirstName = TQCheckBox( 'First &Name', self.search )
        self.cFirstName.resize( self.cFirstName.sizeHint() )
        self.grid2.addWidget( self.cFirstName, 0, 0 )
        self.connect( self.cFirstName, SIGNAL( 'clicked()' ), self.toggleFirstName )

        self.cLastName = TQCheckBox( '&Last Name', self.search )
        self.cLastName.resize( self.cLastName.sizeHint() )
        self.grid2.addWidget( self.cLastName, 0, 1 )
        self.connect( self.cLastName, SIGNAL( 'clicked()' ), self.toggleLastName )

        self.cAddress = TQCheckBox( '&Address', self.search )
        self.cAddress.resize( self.cAddress.sizeHint() )
        self.grid2.addWidget( self.cAddress, 0, 2 )
        self.connect( self.cAddress, SIGNAL( 'clicked()' ), self.toggleAddress )

        self.cEMail = TQCheckBox( '&E-Mail', self.search )
        self.cEMail.resize( self.cEMail.sizeHint() )
        self.grid2.addWidget( self.cEMail, 0, 3 )
        self.connect( self.cEMail, SIGNAL( 'clicked()' ), self.toggleEMail )

        self.sFirstName = TQLineEdit( self.search )
        self.sFirstName.resize( self.sFirstName.sizeHint() )
        self.grid2.addWidget( self.sFirstName, 1, 0 )

        self.sLastName = TQLineEdit( self.search )
        self.sLastName.resize( self.sLastName.sizeHint() )
        self.grid2.addWidget( self.sLastName, 1, 1 )

        self.sAddress = TQLineEdit( self.search )
        self.sAddress.resize( self.sAddress.sizeHint() )
        self.grid2.addWidget( self.sAddress, 1, 2 )

        self.sEMail = TQLineEdit( self.search )
        self.sEMail.resize( self.sEMail.sizeHint() )
        self.grid2.addWidget( self.sEMail, 1, 3 )

        self.find = TQPushButton( '&Find', self.search )
        self.find.resize( self.find.sizeHint() )
        self.grid2.addWidget( self.find, 1, 4 )
        self.connect( self.find, SIGNAL( 'clicked()' ), self.findEntries )

        self.cFirstName.setChecked( TRUE )
        self.sFirstName.setEnabled( TRUE )
        self.sLastName.setEnabled( FALSE )
        self.sAddress.setEnabled( FALSE )
        self.sEMail.setEnabled( FALSE )

        self.tabWidget.addTab( self.search, "&Search" )

        self.mainGrid.addWidget( self.tabWidget, 0, 0 )

    def setupListView( self ):
        self.listView = TQListView( self )
        self.listView.addColumn( 'First Name' )
        self.listView.addColumn( 'Last Name' )
        self.listView.addColumn( 'Address' )
        self.listView.addColumn( 'E-Mail' )

        self.listView.setSelectionMode( TQListView.Extended )

        self.connect( self.listView, SIGNAL( 'clicked( TQListViewItem* )' ), self.itemSelected )

        self.mainGrid.addWidget( self.listView, 1, 0 )
        self.listView.setAllColumnsShowFocus( TRUE )


    def addEntry( self ):
        if not self.iFirstName.text().isEmpty() or not self.iLastName.text().isEmpty() or \
        not self.iAddress.text().isEmpty() or not self.iEMail.text().isEmpty() :
            self.item = TQListViewItem( self.listView )
            self.item.setText( 0, self.iFirstName.text() )
            self.item.setText( 1, self.iLastName.text() )
            self.item.setText( 2, self.iAddress.text() )
            self.item.setText( 3, self.iEMail.text() )
    
        self.iFirstName.setText( '' )
        self.iLastName.setText( '' )
        self.iAddress.setText( '' )
        self.iEMail.setText( '' )

    def changeEntry( self ):
        self.item = self.listView.currentItem()
        if self.item and ( not self.iFirstName.text().isEmpty() or not self.iLastName.text().isEmpty() or \
                      not self.iAddress.text().isEmpty() or not self.iEMail.text().isEmpty() ) :
            self.item.setText( 0, self.iFirstName.text() )
            self.item.setText( 1, self.iLastName.text() )
            self.item.setText( 2, self.iAddress.text() )
            self.item.setText( 3, self.iEMail.text() )
    
    def selectionChanged( self ):
        self.iFirstName.setText( '' )
        self.iLastName.setText( '' )
        self.iAddress.setText( '' )
        self.iEMail.setText( '' )

    def itemSelected( self, item ):
        self.item.setSelected( TRUE )
        self.item.repaint()

        self.iFirstName.setText( item.text( 0 ) )
        self.iLastName.setText( item.text( 1 ) )
        self.iAddress.setText( item.text( 2 ) )
        self.iEMail.setText( item.text( 3 ) )

    def toggleFirstName( self ):
        self.sFirstName.setText( '' )
        if self.cFirstName.isChecked():
            self.sFirstName.setEnabled( TRUE )
            self.sFirstName.setFocus()
        else:
            self.sFirstName.setEnabled( FALSE )

    def toggleLastName( self ):
        self.sLastName.setText( '' )
        if self.cLastName.isChecked():
            self.sLastName.setEnabled( TRUE )
            self.sLastName.setFocus()
        else:
            self.sLastName.setEnabled( FALSE )


    def toggleAddress( self ):
        self.sAddress.setText( '' )
        if self.cAddress.isChecked():
            self.sAddress.setEnabled( TRUE )
            self.sAddress.setFocus()
        else:
            self.sAddress.setEnabled( FALSE )


    def toggleEMail( self ):
        self.sEMail.setText( '' )
        if self.cEMail.isChecked():
            self.sEMail.setEnabled( TRUE )
            self.sEMail.setFocus()
    
        else:
            self.sEMail.setEnabled( FALSE )


    def findEntries( self ):
        if not self.cFirstName.isChecked() and not self.cLastName.isChecked() and \
           not self.cAddress.isChecked() and not self.cEMail.isChecked():
            self.listView.clearSelection()
            return
    
        it = TQListViewItemIterator( self.listView )

        for it in it.current() :
            select = TRUE

            if self.cFirstName.isChecked():
                if select and it.current().text( 0 ).contains( self.sFirstName.text() ):
                    select = TRUE
                else:
                    select = FALSE
        
            if self.cLastName.isChecked():
                if select and it.current().text( 1 ).contains( self.sLastName.text() ):
                    select = TRUE
                else:
                    select = FALSE
        
            if self.cAddress.isChecked():
                if select and it.current().text( 2 ).contains( self.sAddress.text() ):
                    select = TRUE
                else:
                    select = FALSE
        
            if self.cEMail.isChecked():
                if select and it.current().text( 3 ).contains( self.sEMail.text() ):
                    select = TRUE
                else:
                    select = FALSE
        

            if select:
                it.current().setSelected( TRUE )
            else:
                it.current().setSelected( FALSE )
            it.current().repaint()


class ABMainWindow(TQMainWindow):
    def __init__( self ):
        TQMainWindow.__init__( self, None, 'example addressbook application' )

        self.filename = TQString.null
        self.setupMenuBar()
        self.setupFileTools()
        self.setupStatusBar()
        self.setupCentralWidget()

    def setupMenuBar( self ):
        self.file = TQPopupMenu( self )
        self.menuBar().insertItem( '&File', self.file )

        openIcon = TQIconSet( TQPixmap( fileopen ) )
        self.file.insertItem( 'New', self.fileNew, TQt.CTRL + TQt.Key_N )
        self.file.insertItem( openIcon, 'Open', self.fileOpen, TQt.CTRL + TQt.Key_O )
        self.file.insertSeparator()
        saveIcon = TQIconSet( TQPixmap( filesave ) )
        self.file.insertItem( saveIcon, 'Save', self.fileSave, TQt.CTRL + TQt.Key_S )
        self.file.insertItem( 'Save As...', self.fileSaveAs )
        self.file.insertSeparator()
        printIcon = TQIconSet( TQPixmap( fileprint ) )
        self.file.insertItem( printIcon, 'Print...', self.filePrint, TQt.CTRL + TQt.Key_P )
        self.file.insertSeparator()
        #self.file.insertItem( 'Close', self.closeWindow, TQt.CTRL + TQt.Key_W )
        self.file.insertItem('Close', self, SLOT('close()'), TQt.CTRL+TQt.Key_W)
        self.file.insertItem( 'Quit', tqApp, SLOT( 'quit()' ), TQt.CTRL + TQt.Key_Q )

    def setupFileTools( self ):
        pass
        #self.fileTools = TQToolBar( self, 'file operations' )

    def setupStatusBar( self ):
        self.statusBar().message( "Ready", 2000 )

    def setupCentralWidget( self ):
        self.view = ABCentralWidget( self )
        #self.view.show()
        self.setCentralWidget( self.view )

    def closeWindow( self ):
        close()


    def fileNew( self ):
        pass

    def fileOpen( self ):
        fn = TQFileDialog.getOpenFileName( TQString.null, TQString.null, self )
        if not fn.isEmpty():
            self.filename = fn
            self.view.load( self.filename )
    
    def fileSave( self ):
        if self.filename.isEmpty():
            self.fileSaveAs()
            return
        
        self.view.save( self.filename )

    def fileSaveAs( self ):
        fn = TQFileDialog.getSaveFileName( TQString.null, TQString.null, self )
        if not fn.isEmpty():
            self.filename = fn
            self.fileSave
    
    def filePrint( self ):
        pass


a = TQApplication( sys.argv )

mw = ABMainWindow()
#mw.setupMenuBar()
#mw.setupFileTools
#mw.setupStatusBar
#mw.setupCentralWidget
#view = ABCentralWidget()
#mw.setCentralWidget( view )
mw.setCaption( 'Addressbook 1' )
a.setMainWidget( mw )
mw.show()

a.connect( a, SIGNAL( 'lastWindowClosed()' ), a, SLOT( 'quit()' ) )
a.exec_loop()
