#!/usr/bin/env python

# A port to PyTQt of the dclock example from TQt v2.x.


import sys, string
from qt import *


class DigitalClock(TQLCDNumber):
  def __init__(self, parent=None, name=None):
    TQLCDNumber.__init__(self, parent, name)
    self.showingColon = 0
    self.setFrameStyle(TQFrame.Panel | TQFrame.Raised)
    self.setLineWidth(2)
    self.showTime()
    self.normalTimer = self.startTimer(500)
    self.showDateTimer = -1

  def timerEvent(self, e):
    if e.timerId() == self.showDateTimer:
      self.stopDate()
    else:
      if self.showDateTimer == -1:
        self.showTime()
  
  def mousePressEvent(self, e):
    if e.button() == TQt.LeftButton:
      self.showDate()

  def showDate(self):
    if self.showDateTimer != -1:
      return
    d = TQDate.currentDate()
    self.display('%2d %2d' % (d.month(), d.day()))
    self.showDateTimer = self.startTimer(2000)

  def stopDate(self):
    self.killTimer(self.showDateTimer)
    self.showDateTimer = -1
    self.showTime()

  def showTime(self):
    self.showingColon = not self.showingColon
    s = list(str(TQTime.currentTime().toString())[:5]) #.left(5)
    if not self.showingColon:
      s[2] = ' '
    if s[0] == '0':
      s[0] = ' '
    s = string.join(s,'')
    self.display(s)

a = TQApplication(sys.argv)
clock = DigitalClock()
clock.resize(170,80)
a.setMainWidget(clock)
clock.show()
a.exec_loop()
