#!/usr/bin/env python

#****************************************************************************
#** $Id: menu.py,v 1.1.1.1 2002/06/04 23:04:42 phil Exp $
#**
#** Copyright (C) 1992-1998 Troll Tech AS.  All rights reserved.
#**
#** This file is part of an example program for PyTQt.  This example
#** program may be used, distributed and modified without limitation.
#**
#*****************************************************************************/

import sys, string
from qt import *

TRUE  = 1
FALSE = 0

# XPM
p1_xpm = [
"16 16 3 1",
" 	c None",
".	c #000000000000",
"X	c #FFFFFFFF0000",
"                ",
"                ",
"         ....   ",
"        .XXXX.  ",
" .............. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .............. ",
"                "
]

# XPM
p2_xpm = [
"16 16 3 1",
" 	c None",
".	c #000000000000",
"X	c #FFFFFFFFFFFF",
"                ",
"   ......       ",
"   .XXX.X.      ",
"   .XXX.XX.     ",
"   .XXX.XXX.    ",
"   .XXX.....    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .........    ",
"                ",
"                "
]

# XPM
p3_xpm = [
"16 16 3 1",
" 	c None",
".	c #000000000000",
"X	c #FFFFFFFFFFFF",
"                ",
"                ",
"   .........    ",
"  ...........   ",
"  ........ ..   ",
"  ...........   ",
"  ...........   ",
"  ...........   ",
"  ...........   ",
"  ...XXXXX...   ",
"  ...XXXXX...   ",
"  ...XXXXX...   ",
"  ...XXXXX...   ",
"   .........    ",
"                ",
"                "
]

p4_xpm = [
' 16 14 5 1',
'. c #000000',
'# c #848284',
'a c #c6c3c6',
'b c #ffff00',
'c c #ffffff',
'aaaaa.........aa',
'aaaa.cccccccc.aa',
'aaaa.c.....c.aaa',
'aaa.cccccccc.aaa',
'aaa.c.....c....a',
'aa.cccccccc.a.a.',
'a..........a.a..',
'.aaaaaaaaaa.a.a.',
'.............aa.',
'.aaaaaa###aa.a.a',
'.aaaaaabbbaa...a',
'.............a.a',
'a.aaaaaaaaa.a.aa',
'aa...........aaa'
]

#  Auxiliary class to provide fancy menu items with different fonts.
#  Used for the "bold" and "underline" menu items in the options menu.

#class MyMenuItem( TQCustomMenuItem ):
#  def __init__( self, s=None, f=None ):
#      apply( TQCustomMenuItem.__init__,( self, s, f ) )
#      string = TQString( s )
#      font   = TQFont( f )

#  def paint( self, p, TRUE, FALSE, x, y, w, h ) :
#    p.setFont ( font )
#    p.drawText( x, y, w, h, TQt.AlignLeft | TQt.AlignVCenter | TQt.ShowPrefix | TQt.DontClip, string )
#  def sizeHint( self ):
#    return TQFontMetrics( font ).size( TQt.AlignLeft | TQt.AlignVCenter | TQt.ShowPrefix | TQt.DontClip,  string )
    

#
### Implementation of MenuExample class
#

class MenuExample( TQWidget ):
  def __init__( self, parent=None, name=None ):
      apply( TQWidget.__init__,(self, parent, name) )
      self.p1 = TQIconSet( TQPixmap ( p1_xpm ) )
      self.p2 = TQIconSet( TQPixmap ( p2_xpm ) )
      self.p3 = TQIconSet( TQPixmap ( p3_xpm ) )
      self.p4 = TQIconSet( TQPixmap ( p4_xpm ) )
      #openIcon  = TQPixmap()
      #saveIcon  = TQPixmap()
      #printIcon = TQPixmap()

      self.printer = TQPopupMenu( self )
      #CHECK_PTR( self.printer )
      self.printer.insertTearOffHandle()
      self.printer.insertItem( "&Print to printer", self.printDoc )
      self.printer.insertItem( "Print to &file", self.file )
      self.printer.insertItem( "Print to fa&x", self.fax )
      self.printer.insertSeparator()
      self.printer.insertItem( "Printer &Setup", self.printerSetup )

      self.file = TQPopupMenu( self )
      #CHECK_PTR( self.file );
      self.file.insertItem( self.p1, "&Open", self.open, TQt.CTRL+TQt.Key_O )
      self.file.insertItem( self.p2, "&New",  self.news, TQt.CTRL+TQt.Key_N )
      self.file.insertItem( self.p3, "&Save", self.save, TQt.CTRL+TQt.Key_S )
      self.file.insertItem( "&Close", self.closeDoc, TQt.CTRL+TQt.Key_W )
      self.file.insertSeparator()
      self.file.insertItem( self.p4, "&Print", self.printer, TQt.CTRL+TQt.Key_P )
      self.file.insertSeparator()
      self.file.insertItem( "E&xit",  tqApp, SLOT( "quit()" ), TQt.CTRL+TQt.Key_Q )
    
      self.edit = TQPopupMenu( self )
      #CHECK_PTR( self.edit )
      undoID = self.edit.insertItem( "&Undo", self.undo )
      redoID = self.edit.insertItem( "&Redo", self.redo )
      self.edit.setItemEnabled( undoID, TRUE )
      self.edit.setItemEnabled( redoID, FALSE )

      self.options = TQPopupMenu( self )
      #CHECK_PTR( self.options )
      self.options.insertTearOffHandle()
      self.options.setCaption( 'Options' )
      self.options.insertItem( "&Normal Font", self.normal )
      self.options.insertSeparator()

      self.options.polish()  # adjust system settings 
      self.f = TQFont( self.options.font() )
      self.f.setBold( TRUE )
      self.boldID = self.options.insertItem( "&Bold" )
      self.options.setAccel( TQt.CTRL+TQt.Key_B, self.boldID )
      self.options.connectItem( self.boldID, self.bold )

      self.f = TQFont( self.options.font() )
      self.f.setUnderline( TRUE )
      self.underlineID = self.options.insertItem( "&Underline" )
      self.options.setAccel( TQt.CTRL+TQt.Key_U, self.underlineID )
      self.options.connectItem( self.underlineID, self.underline )
    
      self.isBold = FALSE
      self.isUnderline = FALSE
      self.options.setCheckable( TRUE )
    
      self.options = TQPopupMenu()
      #CHECK_PTR( self.options )
      self.options.insertItem( "&Normal Font", self.normal )
      self.options.insertSeparator()
      self.boldID = self.options.insertItem( "&Bold", self.bold )
      self.underlineID = self.options.insertItem( "&Underline", self.underline )

      self.isBold = FALSE
      self.isUnderline = FALSE
      self.options.setCheckable( TRUE )

      self.help = TQPopupMenu( self )
      #CHECK_PTR( self.help )
      self.help.insertItem( "&About", self.about, TQt.CTRL+TQt.Key_H )
      self.help.insertItem( "About &TQt", self.aboutTQt )

      self.menu = TQMenuBar( self )
      #CHECK_PTR( self.menu );
      self.menu.insertItem( "&File", self.file )
      self.menu.insertItem( "&Edit", self.edit )
      self.menu.insertItem( "&Options", self.options )
      self.menu.insertSeparator()
      self.menu.insertItem( "&Help", self.help )
      self.menu.setSeparator( TQMenuBar.InWindowsStyle )

      self.label = TQLabel( self )
      #CHECK_PTR( self.label )
      self.label.setGeometry( 20, self.rect().center().y()-20, self.width()-40, 40 )
      self.label.setFrameStyle( TQFrame.Box | TQFrame.Raised )
      self.label.setLineWidth( 1 )
      self.label.setAlignment( TQt.AlignCenter )
      
      self.label.setFont( TQFont( "times", 12, TQFont.Bold ) )
      self.connect( self, PYSIGNAL( "explain" ), self.label.setText )
      #self.connect( self,  PYSIGNAL( "explain(const char *)" ),
      #              self.label, SLOT( "setText(const char *)" ) )

      self.setMinimumSize( 100, 80 )

  def open( self ):
    self.emit ( PYSIGNAL( "explain" ), ( "File/Open selected", ) )

  def news( self ):
    self.emit ( PYSIGNAL( "explain" ), ( "File/New selected", ) )

  def save( self ):
    self.emit ( PYSIGNAL( "explain" ), ( "File/Save selected", ) )
        
  def closeDoc( self ):
    self.emit ( PYSIGNAL( "explain" ), ( "File/Close selected", ) )

  def undo( self ):
    self.emit ( PYSIGNAL( "explain" ), ( "Edit/Undo selected", ) )

  def redo( self ):
    self.emit ( PYSIGNAL( "explain" ), ( "Edit/Redo selected", ) )

  def normal( self ):
    self.isBold = FALSE
    self.isUnderline = FALSE
    self.options.setItemChecked( self.boldID, self.isBold )
    self.options.setItemChecked( self.underlineID, self.isUnderline )
    self.emit(PYSIGNAL("explain"), ("Options/Normal selected",))

  def bold( self ):
    self.isBold = not self.isBold
    self.options.setItemChecked( self.boldID, self.isBold )
    self.emit ( PYSIGNAL( "explain" ), ( "Options/Bold selected", ) )

  def underline( self ):
    self.isUnderline = not self.isUnderline
    self.options.setItemChecked( self.underlineID, self.isUnderline )
    self.emit(PYSIGNAL("explain"), ("Options/Underline selected",))

  def about( self ):
    TQMessageBox.about( self, "TQt Menu Example",
                       "This example demonstrates simple use of TQt menus.\n"
                       "You can cut and paste lines from it to your own\n"
                       "programs." )

  def aboutTQt( self ):
    TQMessageBox.aboutTQt( self, "TQt Menu Example" )

  def printDoc( self ):
    self.emit ( PYSIGNAL( "explain" ), ( "File/Printer/Print selected", ) )

  def file( self ):
    self.emit ( PYSIGNAL( "explain" ), ( "File/Printer/Print To File selected", ) )

  def fax( self ):
    self.emit ( PYSIGNAL( "explain" ), ( "File/Printer/Print To Fax selected", ) )

  def printerSetup( self ):
    self.emit ( PYSIGNAL( "explain" ), ( "File/Printer/Printer Setup selected", ) )

  def resizeEvent( self, ev ):
    self.label.setGeometry( 20, self.rect().center().y()-20, self.width()-40, 40 )

a = TQApplication( sys.argv )
m = MenuExample()

a.setMainWidget( m )
m.setCaption( 'MenuExample' )
m.show()
#a.connect( a, SIGNAL('lastWindowClosed()'), a, SLOT('quit()') )
a.exec_loop()
