#!/usr/bin/env python

import sys
from qt import *

class Table(TQTableView):
  def __init__(self, numRows, numCols, parent=None, name=''):
    TQTableView.__init__(self, parent, name)
    self.curRow = self.curCol = 0
    self.setFocusPolicy(TQWidget.StrongFocus)
    self.setBackgroundMode(TQWidget.PaletteBase)
    self.setNumCols(numCols)
    self.setNumRows(numRows)
    self.setCellWidth(100)
    self.setCellHeight(30)
    self.setTableFlags(Tbl_vScrollBar |
	               Tbl_hScrollBar |
		       Tbl_clipCellPainting)
    self.resize(400,200)
    self.contents = [''] * (numRows * numCols)
  
  def cellContent(self, row, col):
    return self.contents[self.indexOf(row,col)]

  def setCellContent(self, row, col, c):
    self.contents[self.indexOf(row,col)] = c
    self.updateCell(row, col)

  def paintCell(self, p, row, col):
    w = self.cellWidth(col)
    h = self.cellHeight(row)
    x2 = w-1
    y2 = h-1

    p.drawLine(x2,0,x2,y2)
    p.drawLine(0,y2,x2,y2)

    if row == self.curRow and col == self.curCol:
      if self.hasFocus():
        p.drawRect(0, 0, x2, y2)
      else:
        p.setPen(TQt.DotLine)
        p.drawRect(0, 0, x2, y2)
        p.setPen(TQt.SolidLine)

    p.drawText(0,0,w,h,TQt.AlignCenter,self.contents[self.indexOf(row,col)])

  def mousePressEvent(self, me):
    oldRow = self.curRow
    oldCol = self.curCol
    clickedPos = me.pos()
    self.curRow = self.findRow(clickedPos.y())
    self.curCol = self.findCol(clickedPos.x())
    if self.curRow != oldRow or \
       self.curCol != oldCol:
      self.updateCell(oldRow, oldCol)
      self.updateCell(self.curRow, self.curCol)

  def keyPressEvent(self, ke):
    oldRow = self.curRow
    oldCol = self.curCol
    edge = 0
    key = ke.key()
    if key == Key_Left:
      if self.curCol > 0:
        self.curCol = self.curCol - 1
	edge = self.leftCell()
        if self.curCol < edge:
	  self.setLeftCell(edge-1)
    elif key == Key_Right:
      if self.curCol < self.numCols()-1:
        self.curCol = self.curCol + 1
	edge = self.lastColVisible()
        if self.curCol >= edge:
	  self.setLeftCell(self.leftCell()+1)
    elif key == Key_Up:
      if self.curRow > 0:
        self.curRow = self.curRow - 1
	edge = self.topCell()
        if self.curRow < edge:
	  self.setTopCell(edge-1)
    elif key == Key_Down:
      if self.curRow < self.numRows()-1:
        self.curRow = self.curRow + 1
	edge = self.lastRowVisible()
	if self.curRow >= edge:
	  self.setTopCell(self.topCell()+1)
    else:
      ke.ignore()
      return
    
    if self.curRow != oldRow or \
       self.curCol != oldCol:
      self.updateCell(oldRow, oldCol)
      self.updateCell(self.curRow, self.curCol)

  def focusInEvnet(self, fie):
    self.updateCell(self.curRow, self.curCol)

  def focusOutEvent(self, foe):
    self.updateCell(self.curRow, self.curCol)

  def indexOf(self, row, col):
    return (row * self.numCols()) + col

numRows = 20
numCols = 20
a = TQApplication(sys.argv)
v = Table(numRows, numCols)
for i in range(numRows):
  for j in range(numCols):
    v.setCellContent(i,j,'%d %c' % (j, 65+(i%26)))
a.setMainWidget(v)
v.show()
a.exec_loop()
