#!/usr/bin/env python

# TQt tutorial 6.

import sys
from qt import *


class LCDRange(TQVBox):
    def __init__(self,parent=None,name=None):
        TQVBox.__init__(self,parent,name)

        lcd = TQLCDNumber(2,self,"lcd")
        slider = TQSlider(TQt.Horizontal,self,"slider")
        slider.setRange(0,99)
        slider.setValue(0)
        self.connect(slider,SIGNAL("valueChanged(int)"),lcd,SLOT("display(int)"))


class MyWidget(TQVBox):
    def __init__(self,parent=None,name=None):
        TQVBox.__init__(self,parent,name)

        quit = TQPushButton("Quit",self,"quit")
        quit.setFont(TQFont("Times",18,TQFont.Bold))

        self.connect(quit,SIGNAL("clicked()"),tqApp,SLOT("quit()"))

        grid = TQGrid(4,self)

        for c in range(4):
            for r in range(4):
                LCDRange(grid)


a = TQApplication(sys.argv)

w = MyWidget()
a.setMainWidget(w)
w.show()
a.exec_loop()
