#!/usr/bin/env python

import os, sys, string
from qt import *


if TQT_VERSION < 0x030100:
    print "This example requires TQt v3.1.0 or later."
    sys.exit(1)


FALSE = 0
TRUE  = 1

hasmail_bmp_data = [
"48 48 3 1",
" 	c None",
".	c #000000",
"+	c #FFFFFF",
"................................................",
".............................++++++++++.........",
".............................++++++++++.........",
"........................++++.+++.+.+.++.........",
"......................++++.++++.+.+.+++.........",
".....................+++.....+++.+.+.++.........",
"....................++.......++.+.+.+++.........",
"...................++........++++++++++.........",
"..................++.........++++++++++.........",
".................++..........+++..+.............",
"................++...........+++..+.............",
"...............++............+++.++.............",
"..............+++++++........++++++.............",
".............++++++++++......++++++.............",
"............+++......+++.....++++.+.............",
"...........+++.........++....+++..+.............",
"...........++..........++...++++..+.............",
"..........++............++.+++++..+.............",
"..........++............++++++++..+.............",
".........++....++++++....+++.+++..+.............",
".........++......++......++..+++..+.............",
".........++..............++..+++..+.............",
".........++..............++..+++..+.............",
".........++..............++..++...+.............",
"+++++++..++.+.+..+..+.+..++.......+..+++++++++++",
".........++.+++.+.+.+.+..++.......+.............",
".........++.+.+.+++.+.+..++.......+.............",
".........++.+.+.+.+.+.+..++......++.............",
".........++.+.+.+.+.+.++.++.....++..............",
".........++..............++....++...............",
"..+.+.+..++..............++...++..+.+.+.+.+.+.+.",
".+.+.+.+.++..............++..++..+.+.+.+.+.+.+..",
"..+.+.+..++..............++.++..+.+.+.+.+.+.+.+.",
".+.+.+.+.++..............+++++.+.+.+.+.+.+.+.+..",
"..+.+.+..+++++++++++++++++++.++.+.+.+.+.+.+.+.+.",
".+.+.+.+..+++++++++++++++++..+.+.+.+.+.+.+.+.+..",
"..+.+.+.+..........+...+.....++.+.+.+.+.+.+.+.+.",
".+.+.+.+.+.+.+.+.+.+...+.....+.+.+.+.+.+.+.+.+..",
"..+.+.+.+.+.+.+.+.++...+.....++.+.+.+.+.+.+.+.+.",
".+.+.+.+.+.+.+.+.+.+...+.....+.+.+.+.+.+.+.+.+..",
"..+.+.+.+.+.+.+.+.++...+.....++.+.+.+.+.+.+.+.+.",
".+.+.+.+.+.+.+.+.+.+...+.....+.+.+.+.+.+.+.+.+..",
"..+.+.+.+.+.+.+.+.++...+....+.+.+.+.+.+.+.+.+.+.",
".+.+.+.+.+.+.+.+.+.+...+...+.+.+.+.+.+.+.+.+.+..",
"..+.+.+.+.+.+.+.+.+.+..+..+.+.+.+.+.+.+.+.+.+.+.",
".+.+.+.+.+.+.+.+.+.+.+.+.+.+.+.+.+.+.+.+.+.+.+..",
"..+.+.+.+.+.+.+.+.+.+.+.+.+.+.+.+.+.+.+.+.+.+...",
"................................................"
]

nomail_bmp_data = [
"48 48 3 1",
" 	c None",
".	c #FFFFFF",
"+	c #000000",
"................................................",
"................................................",
"................................................",
".........................++++...................",
".......................++++++++.................",
".....................++++....+++................",
"....................+++........++...............",
"...................++...........++..............",
"..................++............++..............",
".................++..............++.......+.....",
"................++...............++......++.....",
"...............++................++.....+++.....",
"..............+++++++...........+++....++++.....",
".............++++++++++........++++...+++++.....",
"............+++......+++......+++.+..++++++.....",
"...........+++.........++....+++..+.+++.+++.....",
"...........++..........++...+++...++++..+++.....",
"..........++............++.+++...++++...++......",
"..........++............+++++...++++............",
".........++....++++++....+++...++++.............",
".........++......++......++...+++.+.............",
".........++..............++...+++.+.............",
".........++..............++...++..+.............",
".........++..............++.......+.............",
"+++++++..++..............++.......+..+++++++++++",
".........++..............++.......+.............",
".........++..............++.......+.............",
".........++..............++......++.............",
".........++..............++.....++..............",
".........++..............++....++...............",
".........++..............++...++................",
".........++..............++..++.................",
".........++..............++.++..................",
".........++..............+++++..................",
".........+++++++++++++++++++.+..................",
"..........+++++++++++++++++..+..................",
"...................+...+.....+..................",
"...................+...+.....+..................",
"...................+...+.....+..................",
"...................+...+.....+..................",
"...................+...+.....+..................",
"...................+...+.....+..................",
"...................+...+.....+..................",
"...................+...+.....+..................",
"+++.++++++++++.+.+++...+..+++++++++++.++...+++++",
"+.+++..+++.+.+++++.++..+.++.+++..+..+.++.+.++++.",
".++...+.....++...+...+++++++....+....++++++...+.",
"++++++++++++++++++++++++++++++++++++++++++++++++"
]

class Biff(TQWidget):
	def __init__(self):
		TQWidget.__init__(self, None, "Biff - example application")
	
		mail = os.getenv("MAIL")
		fi = TQFileInfo(mail);
		if not fi.exists():
			s = "/var/spool/mail/"+os.getenv("USER") 
			fi.setFile(s)

		if fi.exists():
			self.mailbox = fi.absFilePath()
			self.startTimer(1000)

		self.setMinimumSize(48, 48)
		self.setMaximumSize(48, 48)
		self.resize(48, 48)

		self.hasNewMail = TQPixmap(hasmail_bmp_data)
		self.noNewMail = TQPixmap(nomail_bmp_data)

		self.gotMail = FALSE
		self.lastModified = fi.lastModified()

	def timerEvent(self, te):
		fi = TQFileInfo(self.mailbox)
		newState = ( fi.lastModified().toTime_t() != self.lastModified.toTime_t() and fi.lastModified().toTime_t() > fi.lastRead().toTime_t())
		if newState != self.gotMail:
			if self.gotMail == TRUE:
				self.lastModified = fi.lastModified()
			self.gotMail = newState
			self.repaint(FALSE)

	def paintEvent(self, pe):
		if self.gotMail:
			bitBlt(self, 0, 0, self.hasNewMail)
		else:
			bitBlt(self, 0, 0, self.noNewMail)

	def mousePressEvent(self, me):
		fi = TQFileInfo(self.mailbox)
		lastModified = fi.lastModified()


a = TQApplication(sys.argv)
b = Biff()
a.setMainWidget(b)
b.show()
a.exec_loop()
