# This is part of the dragdrop example.


from qt import *

import secret


class DropSite(TQLabel):
    def __init__(self, parent=None, name=None):
        TQLabel.__init__( self, parent, name )
        self.setAcceptDrops(1)

    # this is a normal event
    def mousePressEvent( self, e ):
        if ( self.pixmap() ) :
            drobj = TQImageDrag( self.pixmap().convertToImage(), self )
            pm = TQPixmap()
            pm.convertFromImage(self.pixmap().convertToImage().smoothScale(
                self.pixmap().width()/3,self.pixmap().height()/3))
            drobj.setPixmap(pm,TQPoint(-5,-7))
        else :
            drobj = TQTextDrag( self.text(), self )
        drobj.dragCopy()

    def backgroundColorChange( self, qcolor ):
        # Reduce flicker by using repaint() rather than update()
        self.repaint()

    def dragMoveEvent( self, e ):
        # Check if you want the drag at e.pos()...
        # Give the user some feedback...
        pass

    def dragEnterEvent( self, e ):
        # Check if you want the drag...
        if (secret.canDecode( e ) or
            TQTextDrag.canDecode( e ) or 
            TQImageDrag.canDecode( e ) or
            TQUriDrag.canDecode( e )):
            e.accept()

        # Give the user some feedback...
        t = ''
        i = 0
        while e.format( i ):
            if ( t != '' ):
                t += "\n"
            t += str(e.format( i ))
            i += 1
        self.emit(PYSIGNAL('message(TQString &)'), (TQString(t),))
        self.setEraseColor(TQt.white)

    def dragLeaveEvent( self, TQDragLeaveEvent ):
        # Give the user some feedback...
        self.emit(PYSIGNAL('message(TQString &)'), (TQString(''),))
        self.setEraseColor(TQt.lightGray)

    def dropEvent( self, e ):
        self.setEraseColor(TQt.lightGray)
        # Try to decode to the data you understand...
        str = TQString()
        if ( TQTextDrag.decode( e, str ) ) :
            self.setText( str )
            self.setMinimumSize( self.minimumSize().expandedTo(self.sizeHint()) )
            return

        pm = TQPixmap()
        if ( TQImageDrag.decode( e, pm ) ) :
            self.setPixmap( pm )
            self.setMinimumSize(self.minimumSize().expandedTo(self.sizeHint()))
            return

        # TQStrList strings
        #strings = TQStrList()
        strings = []
        if ( TQUriDrag.decode( e, strings ) ) :
            m = TQString("Full URLs:\n")
            for u in strings:
                m = m + "   " + u + '\n'
            # TQStringList files
            files = []
            if ( TQUriDrag.decodeLocalFiles( e, files ) ) :
                m += "Files:\n"
                # for (TQStringList.Iterator i=files.begin() i!=files.end() ++i)
                for i in files:
                    m = m + "   " + i + '\n'
            self.setText( m )
            self.setMinimumSize(self.minimumSize().expandedTo(self.sizeHint()))
            return

        str = secret.decode( e ) 
        if str:
            self.setText( str )
            self.setMinimumSize(self.minimumSize().expandedTo(self.sizeHint()))
            return
