#!/usr/bin/env python

#****************************************************************************
#** $Id: lineedits.py,v 1.1 2002/06/19 07:56:07 phil Exp $
#**
#** Copyright (C) 1992-1998 Troll Tech AS.  All rights reserved.
#**
#** This file is part of an example program for PyTQt.  This example
#** program may be used, distributed and modified without limitation.
#**
#*****************************************************************************/

import sys
from qt import *

TRUE  = 1
FALSE = 0

class LineEdits(TQGroupBox):
    def __init__(self, parent = None, name = None):
        TQGroupBox.__init__(self, 0, TQt.Horizontal, "Line Edits", parent, name)

        self.setMargin(10)
        
        box = TQVBoxLayout(self.layout())
        
        row1 = TQHBoxLayout(box)
        row1.setMargin(5)

        label = TQLabel("Echo Mode: ", self)
        row1.addWidget(label)

        combo1 = TQComboBox(FALSE, self)
        row1.addWidget(combo1)
        combo1.insertItem("Normal", -1)
        combo1.insertItem("Password", -1)
        combo1.insertItem("No Echo", -1)

        self.connect(combo1, SIGNAL("activated(int)"), self.slotEchoChanged)
        self.lined1 = TQLineEdit(self)
        box.addWidget(self.lined1)

        row2 = TQHBoxLayout(box)
        row2.setMargin(5)

        label = TQLabel("Validator: ", self)
        row2.addWidget(label)

        combo2 = TQComboBox(FALSE, self)
        row2.addWidget(combo2)
        combo2.insertItem("No Validator", -1)
        combo2.insertItem("Integer Validator", -1)
        combo2.insertItem("Double Validator", -1)
        
        self.connect(combo2, SIGNAL("activated(int)"), self.slotValidatorChanged)

        self.lined2 = TQLineEdit(self)
        box.addWidget(self.lined2)

        row3 = TQHBoxLayout(box)
        row3.setMargin(5)

        label = TQLabel("Alignment: ", self)
        row3.addWidget(label)

        combo3 = TQComboBox(FALSE, self)
        row3.addWidget(combo3)
        combo3.insertItem("Left", -1)
        combo3.insertItem("Centered", -1)
        combo3.insertItem("Right", -1)

        self.connect(combo3, SIGNAL("activated(int)"), self.slotAlignmentChanged)
        self.lined3 = TQLineEdit(self)
        box.addWidget(self.lined3)

        row4 = TQHBox(self)
        box.addWidget(row4)
        row4.setMargin(5)

        TQLabel("Read-Only: ", row4)

        combo4 = TQComboBox(FALSE, row4)
        combo4.insertItem("False", -1)
        combo4.insertItem("True", -1)

        self.connect(combo4, SIGNAL("activated(int)"), self.slotReadOnlyChanged)

        self.lined4 = TQLineEdit(self)
        box.addWidget(self.lined4)

        self.lined1.setFocus()

    def slotEchoChanged(self, i):
        if i == 0:
            self.lined1.setEchoMode(TQLineEdit.Normal)
        elif i == 1:
            self.lined1.setEchoMode(TQLineEdit.Password)
        elif i == 2:
            self.lined1.setEchoMode(TQLineEdit.NoEcho)

        self.lined1.setFocus()

    def slotValidatorChanged(self, i):
        if i == 0:
            self.lined2.setValidator(None)
        elif i == 1:
            self.lined2.setValidator(TQIntValidator(self.lined2))
        elif i == 2:
            self.lined2.setValidator(TQDoubleValidator(-999.0, 999.0, 2, self.lined2))

        self.lined2.setText("")
        self.lined2.setFocus()

    def slotAlignmentChanged(self, i):
        if i == 0:
            self.lined3.setAlignment(TQLineEdit.AlignLeft)
        elif i == 1:
            self.lined3.setAlignment(TQLineEdit.AlignCenter)
        elif i == 2:
            self.lined3.setAlignment(TQLineEdit.AlignRight)

        self.lined3.setFocus()

    def slotReadOnlyChanged(self, i):
        if i == 0:
            self.lined4.setReadOnly(FALSE)
        elif i == 1:
            self.lined4.setReadOnly(TRUE)

        self.lined4.setFocus()


if __name__=='__main__':
    app = TQApplication( sys.argv )

    lineedits = LineEdits()
    lineedits.setCaption("Lineedits - PyTQt Example")
    lineedits.show()
    app.setMainWidget(lineedits)
    app.exec_loop()
