#!/usr/bin/env python

#****************************************************************************
#** $Id: menu.py,v 1.3 2003/06/06 12:59:26 phil Exp $
#**
#** Copyright (C) 1992-1998 Troll Tech AS.  All rights reserved.
#**
#** This file is part of an example program for PyTQt.  This example
#** program may be used, distributed and modified without limitation.
#**
#*****************************************************************************/

import sys, string
from qt import *

TRUE  = 1
FALSE = 0

# XPM
p1_xpm = [
"16 16 3 1",
" 	c None",
".	c #000000000000",
"X	c #FFFFFFFF0000",
"                ",
"                ",
"         ....   ",
"        .XXXX.  ",
" .............. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .XXXXXXXXXXXX. ",
" .............. ",
"                "
]

# XPM
p2_xpm = [
"16 16 3 1",
" 	c None",
".	c #000000000000",
"X	c #FFFFFFFFFFFF",
"                ",
"   ......       ",
"   .XXX.X.      ",
"   .XXX.XX.     ",
"   .XXX.XXX.    ",
"   .XXX.....    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .XXXXXXX.    ",
"   .........    ",
"                ",
"                "
]

# XPM
p3_xpm = [
"16 16 3 1",
" 	c None",
".	c #000000000000",
"X	c #FFFFFFFFFFFF",
"                ",
"                ",
"   .........    ",
"  ...........   ",
"  ........ ..   ",
"  ...........   ",
"  ...........   ",
"  ...........   ",
"  ...........   ",
"  ...XXXXX...   ",
"  ...XXXXX...   ",
"  ...XXXXX...   ",
"  ...XXXXX...   ",
"   .........    ",
"                ",
"                "
]


# Auxiliary class to provide fancy menu items with different fonts.
# Used for the "bold" and "underline" menu items in the options menu.

class MyMenuItem( TQCustomMenuItem ):
    def __init__( self, s, f ):
        TQCustomMenuItem.__init__( self )
        self.string = s
        self.font   = f

    def paint( self, p, cg, act, enabled, x, y, w, h ) :
        p.setFont ( self.font )
        p.drawText( x, y, w, h, TQt.AlignLeft | TQt.AlignVCenter | TQt.ShowPrefix | TQt.DontClip, self.string )

    def sizeHint( self ):
        return TQFontMetrics( self.font ).size( TQt.AlignLeft | TQt.AlignVCenter | TQt.ShowPrefix | TQt.DontClip,  self.string )


# Implementation of MenuExample class

class MenuExample( TQWidget ):
    def __init__( self, parent=None, name=None ):
        TQWidget.__init__( self, parent, name )
        self.p1 = TQIconSet( TQPixmap ( p1_xpm ) )
        self.p2 = TQIconSet( TQPixmap ( p2_xpm ) )
        self.p3 = TQIconSet( TQPixmap ( p3_xpm ) )

        self.printer = TQPopupMenu( self )
        self.printer.insertTearOffHandle()
        self.printer.insertItem( "&Print to printer", self.printDoc )
        self.printer.insertItem( "Print to &file", self.printFile )
        self.printer.insertItem( "Print to fa&x", self.fax )
        self.printer.insertSeparator()
        self.printer.insertItem( "Printer &Setup", self.printerSetup )

        self.file = TQPopupMenu( self )
        self.file.insertItem( self.p1, "&Open", self.open, TQt.CTRL+TQt.Key_O )
        self.file.insertItem( self.p2, "&New",  self.news, TQt.CTRL+TQt.Key_N )
        self.file.insertItem( self.p3, "&Save", self.save, TQt.CTRL+TQt.Key_S )
        self.file.insertItem( "&Close", self.closeDoc, TQt.CTRL+TQt.Key_W )
        self.file.insertSeparator()
        self.file.insertItem( "&Print", self.printer, TQt.CTRL+TQt.Key_P )
        self.file.insertSeparator()
        self.file.insertItem( "E&xit",  tqApp, SLOT( "quit()" ), TQt.CTRL+TQt.Key_Q )

        self.edit = TQPopupMenu( self )
        undoID = self.edit.insertItem( "&Undo", self.undo )
        redoID = self.edit.insertItem( "&Redo", self.redo )
        self.edit.setItemEnabled( undoID, FALSE )
        self.edit.setItemEnabled( redoID, FALSE )

        self.options = TQPopupMenu( self )
        self.options.insertTearOffHandle()
        self.options.setCaption( "Options" )
        self.options.insertItem( "&Normal Font", self.normal )
        self.options.insertSeparator()

        self.options.polish()  # adjust system settings
        f = self.options.font()
        f.setBold( TRUE )
        self.boldID = self.options.insertItem( MyMenuItem( "Bold", f ) )
        self.options.setAccel( TQt.CTRL+TQt.Key_B, self.boldID )
        self.options.connectItem( self.boldID, self.bold )

        f = self.options.font()
        f.setUnderline( TRUE )
        self.underlineID = self.options.insertItem( MyMenuItem( "Underline", f ) )
        self.options.setAccel( TQt.CTRL+TQt.Key_U, self.underlineID )
        self.options.connectItem( self.underlineID, self.underline )

        self.isBold = FALSE
        self.isUnderline = FALSE
        self.options.setCheckable( TRUE )

        self.help = TQPopupMenu( self )
        self.help.insertItem( "&About", self.about, TQt.CTRL+TQt.Key_H )
        self.help.insertItem( "About &TQt", self.aboutTQt )

        self.menu = TQMenuBar( self )
        self.menu.insertItem( "&File", self.file )
        self.menu.insertItem( "&Edit", self.edit )
        self.menu.insertItem( "&Options", self.options )
        self.menu.insertSeparator()
        self.menu.insertItem( "&Help", self.help )
        self.menu.setSeparator( TQMenuBar.InWindowsStyle )

        msg = TQLabel( self )
        msg.setText( "A context menu is available.\n"
                     "Invoke it by right-clicking or by"
                     " pressing the 'context' button." )
        msg.setGeometry( 0, self.height() - 60, self.width(), 60 )
        msg.setAlignment( TQt.AlignCenter )

        self.label = TQLabel( self )
        self.label.setGeometry( 20, self.rect().center().y()-20, self.width()-40, 40 )
        self.label.setFrameStyle( TQFrame.Box | TQFrame.Raised )
        self.label.setLineWidth( 1 )
        self.label.setAlignment( TQt.AlignCenter )

        self.connect( self, PYSIGNAL( "explain" ), self.label, SLOT( "setText(const TQString &" ) )

        self.setMinimumSize( 100, 80 )
        self.setFocusPolicy( TQWidget.ClickFocus )

    def contextMenuEvent(self, cmev):
        contextMenu = TQPopupMenu( self )
        caption = TQLabel( "<font color=darkblue><u><b>Context Menu</b></u></font>", self )
        caption.setAlignment( TQt.AlignCenter )
        contextMenu.insertItem( caption )
        contextMenu.insertItem( "&New", self.news, TQt.CTRL+TQt.Key_N )
        contextMenu.insertItem( "&Open...", self.open, TQt.CTRL+TQt.Key_O )
        contextMenu.insertItem( "&Save", self.save, TQt.CTRL+TQt.Key_S )
        submenu = TQPopupMenu( self )
        submenu.insertItem( "&Print to printer", self.printDoc )
        submenu.insertItem( "Print to &file", self.printFile )
        submenu.insertItem( "Print to fa&x", self.fax )
        contextMenu.insertItem( "&Print", submenu )
        contextMenu.exec_loop( TQCursor.pos() )

    def open( self ):
        self.emit( PYSIGNAL( "explain" ), ( "File/Open selected", ) )

    def news( self ):
        self.emit( PYSIGNAL( "explain" ), ( "File/New selected", ) )

    def save( self ):
        self.emit( PYSIGNAL( "explain" ), ( "File/Save selected", ) )

    def closeDoc( self ):
        self.emit( PYSIGNAL( "explain" ), ( "File/Close selected", ) )

    def undo( self ):
        self.emit( PYSIGNAL( "explain" ), ( "Edit/Undo selected", ) )

    def redo( self ):
        self.emit( PYSIGNAL( "explain" ), ( "Edit/Redo selected", ) )

    def normal( self ):
        self.isBold = FALSE
        self.isUnderline = FALSE
        font = TQFont()
        self.label.setFont( font )
        self.options.setItemChecked( self.boldID, self.isBold )
        self.options.setItemChecked( self.underlineID, self.isUnderline )
        self.emit( PYSIGNAL( "explain" ), ( "Options/Normal selected", ) )

    def bold( self ):
        self.isBold = not self.isBold
        font = TQFont()
        font.setBold( self.isBold )
        font.setUnderline( self.isUnderline )
        self.label.setFont( font )
        self.options.setItemChecked( self.boldID, self.isBold )
        self.emit( PYSIGNAL( "explain" ), ( "Options/Bold selected", ) )

    def underline( self ):
        self.isUnderline = not self.isUnderline
        font = TQFont()
        font.setBold( self.isBold )
        font.setUnderline( self.isUnderline )
        self.label.setFont( font )
        self.options.setItemChecked( self.underlineID, self.isUnderline )
        self.emit( PYSIGNAL("explain"), ( "Options/Underline selected", ))

    def about( self ):
        TQMessageBox.about( self, "TQt Menu Example",
                       "This example demonstrates simple use of TQt menus.\n"
                       "You can cut and paste lines from it to your own\n"
                       "programs." )

    def aboutTQt( self ):
        TQMessageBox.aboutTQt( self, "TQt Menu Example" )

    def printDoc( self ):
        self.emit( PYSIGNAL( "explain" ), ( "File/Printer/Print selected", ) )

    def printFile( self ):
        self.emit( PYSIGNAL( "explain" ), ( "File/Printer/Print To File selected", ) )

    def fax( self ):
        self.emit( PYSIGNAL( "explain" ), ( "File/Printer/Print To Fax selected", ) )

    def printerSetup( self ):
        self.emit( PYSIGNAL( "explain" ), ( "File/Printer/Printer Setup selected", ) )

    def resizeEvent( self, ev ):
        self.label.setGeometry( 20, self.rect().center().y()-20, self.width()-40, 40 )


a = TQApplication( sys.argv )
m = MenuExample()

m.setCaption( "TQt Examples - Menus" )
a.setMainWidget( m )
m.show()
a.exec_loop()
