# This is part of the dragdrop example.


from qt import *


def canDecode(e):
    return e.provides( "secret/magic" )


def decode(e): 
    payload = str(e.data( "secret/magic" ))
    if ( str(payload) != '' ):
        e.accept()
        return TQString("The secret number is "+str(ord(payload)) )

    return None


class SecretDrag(TQStoredDrag):
    def __init__(self, secret, parent=None, name=None):
        TQStoredDrag.__init__(self, 'secret/magic', parent, name)
        data = TQByteArray(chr(secret))
        self.setEncodedData( data )

        
# XPM 
picture_xpm = [
    "16 16 3 1",
    " 	c None",
    ".	c #000000",
    "X	c #FFFF00",
    "     .....      ",
    "   ..XXXXX..    ",
    "  .XXXXXXXXX.   ",
    " .XXXXXXXXXXX.  ",
    " .XX..XXX..XX.  ",
    ".XXXXXXXXXXXXX. ",
    ".XX...XXX...XX. ",
    ".XXX..XXX..XXX. ",
    ".XXXXXXXXXXXXX. ",
    ".XXXXXX.XXXXXX. ",
    " .XX.XX.XX.XX.  ",
    " .XXX..X..XXX.  ",
    "  .XXXXXXXXX.   ",
    "   ..XXXXX..    ",
    "     .....      ",
    "                "
]


class SecretSource(TQLabel):
    def __init__(self, secret, parent=None, name=None):
        TQLabel.__init__(self, "Secret", parent, name)
        self.setEraseColor( TQt.blue.light() )
        self.setFrameStyle( TQLabel.Box | TQLabel.Sunken )
        self.setMinimumHeight( self.sizeHint().height()*2 )
        self.setAlignment( TQLabel.AlignCenter )
        self.mySecret = secret

    def mousePressEvent(self, e): 
        sd = SecretDrag( self.mySecret, self )
        sd.setPixmap(TQPixmap(picture_xpm),TQPoint(8,8))
        sd.dragCopy()
        self.mySecret = self.mySecret + 1
