#!/usr/bin/env python

"""**************************************************************************
** $Id: tabdialog.py,v 1.1 2003/07/01 14:18:37 phil Exp $
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of an example program for TQt.  This example
** program may be used, distributed and modified without limitation.
**
***************************************************************************"""

import sys
from qt import *

class TabDialog( TQTabDialog ):
    def __init__( self, parent=None, name=None, filename=None ):
        TQTabDialog.__init__( self, parent, name )
        self.filename = TQString( filename )
        self.fileinfo = TQFileInfo( filename )
        self.setupTab1()
        self.setupTab2()
        self.setupTab3()
        self.connect( self, SIGNAL("applyButtonPressed()"), tqApp, SLOT("quit()" ) )

    def setupTab1( self ):
        tab1 = TQVBox( self )
        tab1.setMargin( 5 )

        TQLabel( "Filename:", tab1 )
        fname = TQLineEdit( self.filename, tab1 )
        fname.setFocus()

        TQLabel( "Path:", tab1 )
        path = TQLabel( self.fileinfo.dirPath( True ), tab1 )
        path.setFrameStyle( TQFrame.Panel | TQFrame.Sunken )

        TQLabel( "Size:", tab1 )
        size = TQLabel( TQString( "%1 KB" ).arg( self.fileinfo.size() ), tab1 )
        size.setFrameStyle( TQFrame.Panel | TQFrame.Sunken )

        TQLabel( "Last Read:", tab1 )
        lread = TQLabel( self.fileinfo.lastRead().toString(), tab1 )
        lread.setFrameStyle( TQFrame.Panel | TQFrame.Sunken )

        TQLabel( "Last Modified:", tab1 )
        lmodif = TQLabel( self.fileinfo.lastModified().toString(), tab1 )
        lmodif.setFrameStyle( TQFrame.Panel | TQFrame.Sunken )

        self.addTab( tab1, "General" )
   
    def setupTab2( self ):
        tab2 = TQVBox( self )
        tab2.setMargin( 5 )

        bg = TQButtonGroup( 1, TQGroupBox.Horizontal, "Permissions", tab2 )

        readable = TQCheckBox( "Readable", bg )
        if self.fileinfo.isReadable() :
            readable.setChecked( True )

        writable = TQCheckBox( "Writeable", bg )
        if self.fileinfo.isWritable() :
            writable.setChecked( True )

        executable = TQCheckBox( "Executable", bg )
        if self.fileinfo.isExecutable() :
            executable.setChecked( True )

        bg2 = TQButtonGroup( 2, TQGroupBox.Horizontal, "Owner", tab2 )

        TQLabel( "Owner", bg2 )
        owner = TQLabel( self.fileinfo.owner(), bg2 )
        owner.setFrameStyle( TQFrame.Panel | TQFrame.Sunken )

        TQLabel( "Group", bg2 )
        group = TQLabel( self.fileinfo.group(), bg2 )
        group.setFrameStyle( TQFrame.Panel | TQFrame.Sunken )

        self.addTab( tab2, "Permissions" )
    
    def setupTab3( self ):
        tab3 = TQVBox( self )
        tab3.setMargin( 5 )
        tab3.setSpacing( 5 )
    
        TQLabel( TQString( "Open %1 with:" ).arg( self.filename ), tab3 )

        prgs = TQListBox( tab3 )
        for i in range( 0, 30, 1 ) :
            prg = TQString( "Application %1" ).arg( i )
            prgs.insertItem( prg )
        prgs.setCurrentItem( 3 )

        TQCheckBox( TQString( "Open files with the extension '%1' always with this application" ).arg( self.fileinfo.extension() ), tab3 )

        self.addTab( tab3, "Applications" )
    
def main( args ):
    a = TQApplication(sys.argv)
    #sys.argv.append("tabdialog.py") # to test uncomment this line
    if len(sys.argv) < 2:
        filename = TQString(".")
    else:
        filename = TQString(sys.argv[1])
            
    tabdialog = TabDialog( None, "tabdialog", filename )
    tabdialog.resize( 450, 350 );
    tabdialog.setCaption( "TQt Example - Tabbed Dialog" )
    a.setMainWidget( tabdialog )
    tabdialog.show()
    
    a.exec_loop()
    
if __name__=="__main__":
    main(sys.argv)
