#!/usr/bin/env python

# TQt tutorial 8.

import sys
import qt


class LCDRange(qt.TQVBox):
    def __init__(self, parent=None, name=None):
        qt.TQVBox.__init__(self, parent, name)

        lcd = qt.TQLCDNumber(2, self, "lcd")
        self.slider = qt.TQSlider(qt.TQt.Horizontal, self, "slider")
        self.slider.setRange(0, 99)
        self.slider.setValue(0)
        self.connect(self.slider, qt.SIGNAL("valueChanged(int)"), lcd, qt.SLOT("display(int)"))
        self.connect(self.slider, qt.SIGNAL("valueChanged(int)"), self, qt.PYSIGNAL("valueChanged(int)"))

        self.setFocusProxy(self.slider)

    def value(self):
        return self.slider.value()

    def setValue(self, value):
        self.slider.setValue(value)

    def setRange(self, minVal, maxVal):
        if minVal < 0 or maxVal > 99 or minVal > maxVal:
            raise ValueError, "LCDRange.setRange(): invalid range"

        self.slider.setRange(minVal, maxVal)


class CannonField(qt.TQWidget):
    def __init__(self, parent=None, name=None):
        qt.TQWidget.__init__(self, parent, name)

        self.ang = 45
        self.setPalette(qt.TQPalette(qt.TQColor(250, 250, 200)))

    def angle(self):
        return self.ang

    def setAngle(self, degrees):
        if degrees < 5:
            degrees = 5
        if degrees > 70:
            degrees = 70
        if self.ang == degrees:
            return
        self.ang = degrees
        self.repaint()
        self.emit(qt.PYSIGNAL("angleChanged(int)"), (self.ang, ))

    def paintEvent(self, ev):
        p = qt.TQPainter(self)
        p.drawText(200, 200, "Angle = %d" % (self.ang))

    def sizePolicy(self):
        return qt.TQSizePolicy(qt.TQSizePolicy.Expanding, qt.TQSizePolicy.Expanding)


class MyWidget(qt.TQWidget):
    def __init__(self, parent=None, name=None):
        qt.TQWidget.__init__(self, parent, name)

        quit = qt.TQPushButton("Quit", self, "quit")
        quit.setFont(qt.TQFont("Times", 18, qt.TQFont.Bold))
        self.connect(quit, qt.SIGNAL("clicked()"), qt.qApp, qt.SLOT("quit()"))

        self.angle = LCDRange(self, "angle")
        self.angle.setRange(5, 70)

        self.cannonField = CannonField(self, "cannonField")

        self.connect(self.angle, qt.PYSIGNAL("valueChanged(int)"), self.cannonField.setAngle)
        self.connect(self.cannonField, qt.PYSIGNAL("angleChanged(int)"), self.angle.setValue)

        grid = qt.TQGridLayout(self, 2, 2, 10)

        grid.addWidget(quit, 0, 0)
        grid.addWidget(self.angle, 1, 0, qt.TQt.AlignTop)
        grid.addWidget(self.cannonField, 1, 1)
        grid.setColStretch(1, 10)

        self.angle.setValue(60)
        self.angle.setFocus()


a = qt.TQApplication(sys.argv)

w = MyWidget()
w.setGeometry(100, 100, 500, 355)
a.setMainWidget(w)
w.show()
sys.exit(a.exec_loop())
